/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.api.config;

import com.flemmli97.tenshilib.api.config.ItemWrapper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;

public class SimpleItemStackWrapper
extends ItemWrapper {
    protected int count;

    public SimpleItemStackWrapper(String s, int count) {
        super(s);
        this.count = count;
    }

    public SimpleItemStackWrapper setIgnoreAmount() {
        this.count = 1;
        return this;
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = super.getStack();
        if (!stack.func_190926_b()) {
            stack.func_190920_e(this.count);
        }
        return stack;
    }

    @Override
    public SimpleItemStackWrapper readFromString(String s) {
        String[] parts = s.split(",");
        super.readFromString(parts[0]);
        this.count = parts.length < 2 ? 1 : Integer.parseInt(parts[1]);
        return this;
    }

    @Override
    public String writeToString() {
        return super.writeToString() + (this.count != 1 ? "," + this.count : "");
    }

    public static String usage() {
        return "Usage: registryname,<amount>. Leave empty for no item";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleItemStackWrapper) {
            SimpleItemStackWrapper prop = (SimpleItemStackWrapper)obj;
            return prop.toString().equals(this.toString());
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<SimpleItemStackWrapper>,
    JsonSerializer<SimpleItemStackWrapper> {
        public JsonElement serialize(SimpleItemStackWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            return obj;
        }

        public SimpleItemStackWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = 1;
            if (obj.get("count") instanceof JsonPrimitive && obj.get("count").getAsJsonPrimitive().isNumber()) {
                count = obj.get("count").getAsInt();
            }
            return new SimpleItemStackWrapper(obj.get("item").getAsString(), count);
        }
    }
}

